/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type.conflict;

import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.command.argument.RecipeTypeArgument;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.impl.command.type.conflict.DescriptiveFilter;
import com.blamejared.crafttweaker.impl.command.type.conflict.RecipeLongIterator;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessRecipeManager;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.ToIntBiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_8786;

public final class ConflictCommand {
    private static final ExecutorService OFF_THREAD_SERVICE = Executors.newFixedThreadPool(1, r -> {
        Thread t = new Thread(r, "crafttweaker:conflict_resolution_thread");
        t.setDaemon(true);
        t.setContextClassLoader(ConflictCommand.class.getClassLoader());
        return t;
    });

    private ConflictCommand() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("conflicts", class_2561.method_43471((String)"crafttweaker.command.description.conflicts"), builder -> ((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(class_2170.method_9244((String)"type", (ArgumentType)RecipeTypeArgument.get()).executes(context -> ConflictCommand.conflicts((class_2168)context.getSource(), DescriptiveFilter.of((IRecipeManager)context.getArgument("type", IRecipeManager.class)))))).then(class_2170.method_9247((String)"hand").executes(context -> ConflictCommand.ifNotEmpty((CommandContext<class_2168>)context, (player, item) -> ConflictCommand.conflicts((class_2168)context.getSource(), DescriptiveFilter.of(item)))))).executes(context -> ConflictCommand.conflicts((class_2168)context.getSource(), DescriptiveFilter.of())));
    }

    private static int ifNotEmpty(CommandContext<class_2168> context, ToIntBiFunction<class_1657, class_1799> command) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        class_1799 stack = player.method_6047();
        if (stack.method_7960()) {
            CommandUtilities.send(source, (class_2561)class_2561.method_43471((String)"crafttweaker.command.conflict.hand.empty").method_27692(class_124.field_1061));
            return -1;
        }
        return command.applyAsInt((class_1657)player, stack);
    }

    private static int conflicts(class_2168 source, DescriptiveFilter filter) {
        CommandUtilities.send(source, (class_2561)class_2561.method_43469((String)"crafttweaker.command.conflict.begin", (Object[])new Object[]{filter.description()}).method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43471((String)"crafttweaker.command.conflict.warnings").method_27692(class_124.field_1061)));
        ConflictCommand.runConflicts(source, source.method_9225().method_8433(), filter);
        return 0;
    }

    private static void runConflicts(class_2168 source, class_1863 manager, DescriptiveFilter filter) {
        Multimap<class_3956<?>, class_8786<?>> recipes = ConflictCommand.copyAndFilter(((AccessRecipeManager)manager).crafttweaker$getByType(), filter);
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> ConflictCommand.computeConflicts(recipes), OFF_THREAD_SERVICE).thenAcceptAsync(message -> ConflictCommand.dispatchCompletionTo(message, source), (Executor)OFF_THREAD_SERVICE)).exceptionallyAsync(exception -> ConflictCommand.dispatchExceptionTo(exception, source), (Executor)OFF_THREAD_SERVICE);
    }

    private static Multimap<class_3956<?>, class_8786<?>> copyAndFilter(Multimap<class_3956<?>, class_8786<?>> original, DescriptiveFilter filter) {
        ListMultimap build = MultimapBuilder.hashKeys().arrayListValues().build();
        HashMultimap clone = HashMultimap.create();
        original.asMap().forEach((arg_0, arg_1) -> ConflictCommand.lambda$copyAndFilter$9((Multimap)build, filter, arg_0, arg_1));
        return clone;
    }

    private static String computeConflicts(Multimap<class_3956<?>, class_8786<?>> recipes) {
        return recipes.asMap().entrySet().stream().flatMap(ConflictCommand::computeConflictsFor).map(it -> "- " + it).collect(Collectors.joining("\n"));
    }

    private static Stream<String> computeConflictsFor(Map.Entry<class_3956<?>, Collection<class_8786<?>>> entry) {
        IRecipeManager<class_1860<?>> manager = RecipeTypeBracketHandler.getOrDefault(entry.getKey());
        if (manager == null) {
            return Stream.empty();
        }
        ArrayList recipes = new ArrayList(entry.getValue());
        RecipeLongIterator iterator = new RecipeLongIterator(recipes.size());
        int characteristics = 1300;
        return StreamSupport.longStream(Spliterators.spliterator(iterator, iterator.estimateLength(), 1300), false).filter(it -> ConflictCommand.conflictsWith(manager, recipes, it)).mapToObj(it -> Map.entry((class_8786)recipes.get(RecipeLongIterator.first(it)), (class_8786)recipes.get(RecipeLongIterator.second(it)))).map(it -> ConflictCommand.formatConflict(manager, it));
    }

    private static boolean conflictsWith(IRecipeManager<?> manager, List<class_8786<?>> recipes, long id) {
        return ConflictCommand.conflictsWith(manager, recipes.get(RecipeLongIterator.first(id)), recipes.get(RecipeLongIterator.second(id)));
    }

    private static <T extends class_1860<?>> boolean conflictsWith(IRecipeManager<?> manager, class_8786<T> first, class_8786<?> second) {
        return first != second && IRecipeHandlerRegistry.getHandlerFor(first.comp_1933()).doesConflict((IRecipeManager)GenericUtil.uncheck(manager), first.comp_1933(), second.comp_1933());
    }

    private static String formatConflict(IRecipeManager<?> manager, Map.Entry<class_8786<?>, class_8786<?>> conflictNames) {
        class_2960 firstName = conflictNames.getKey().comp_1932();
        class_2960 secondName = conflictNames.getValue().comp_1932();
        return String.format("Recipes '%s' and '%s' in type '%s' have conflicting inputs", firstName, secondName, manager.getCommandString());
    }

    private static void dispatchCompletionTo(String message, class_2168 source) {
        ConflictCommand.onMainThread(source, () -> {
            try {
                CommandUtilities.COMMAND_LOGGER.info(message.isEmpty() ? "No conflicts identified" : message);
                CommandUtilities.openLogFile(source, (class_2561)class_2561.method_43471((String)"crafttweaker.command.conflict.complete").method_27692(class_124.field_1060));
            }
            catch (Exception e) {
                try {
                    CommandUtilities.COMMAND_LOGGER.error("An error occurred while reporting conflicts, hopefully it does not happen again", (Throwable)e);
                }
                catch (Exception another) {
                    e.addSuppressed(another);
                    e.printStackTrace(System.err);
                }
            }
        });
    }

    private static Void dispatchExceptionTo(Throwable exception, class_2168 source) {
        ConflictCommand.onMainThread(source, () -> {
            try {
                CommandUtilities.COMMAND_LOGGER.error("Unable to verify for conflicts due to an exception", exception);
                CommandUtilities.openLogFile(source, (class_2561)class_2561.method_43471((String)"crafttweaker.command.conflict.error").method_27692(class_124.field_1061));
            }
            catch (Exception e) {
                try {
                    CommandUtilities.COMMAND_LOGGER.error("An error occurred while reporting conflicts, hopefully it does not happen again", (Throwable)e);
                }
                catch (Exception another) {
                    e.addSuppressed(another);
                    e.printStackTrace(System.err);
                }
            }
        });
        return null;
    }

    private static void onMainThread(class_2168 source, Runnable runnable) {
        class_3218 level = source.method_9225();
        assert (!level.method_8608());
        Objects.requireNonNull(level.method_8503(), "Is someone running server-bound commands on the client?").method_40000(() -> {
            try {
                runnable.run();
            }
            catch (RejectedExecutionException e) {
                OFF_THREAD_SERVICE.submit(runnable);
            }
        });
    }

    private static /* synthetic */ void lambda$copyAndFilter$9(Multimap build, DescriptiveFilter filter, class_3956 type, Collection holders) {
        build.putAll((Object)type, holders.stream().filter(filter).toList());
    }
}

